<?php
// Check permission
if (!hasPermission('manage_departments')) {
    echo "<div class='alert alert-danger'><i class='bi bi-shield-exclamation'></i> Access Denied</div>";
    exit();
}

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['add_department'])) {
        $department_name = $_POST['department_name'];
        $manager_id = $_POST['manager_id'] ?? null;
        
        $stmt = $pdo->prepare("INSERT INTO departments (department_name, manager_id) VALUES (?, ?)");
        $stmt->execute([$department_name, $manager_id]);
        
        echo "<div class='alert alert-success'>Department added successfully!</div>";
    }
}

// Get all departments
$stmt = $pdo->query("SELECT d.*, e.full_name as manager_name FROM departments d 
                     LEFT JOIN employees e ON d.manager_id = e.id 
                     ORDER BY d.department_name");
$departments = $stmt->fetchAll();

// Get all managers
$stmt = $pdo->query("SELECT e.* FROM employees e 
                     JOIN users u ON e.user_id = u.id 
                     WHERE u.role IN ('admin', 'manager') AND u.is_active = 1 
                     ORDER BY e.full_name");
$managers = $stmt->fetchAll();
?>

<div class="row">
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-building-add me-2"></i>Add Department</h5>
            </div>
            <div class="card-body">
                <form method="POST">
                    <div class="mb-3">
                        <label>Department Name</label>
                        <input type="text" name="department_name" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Department Manager (Optional)</label>
                        <select name="manager_id" class="form-control">
                            <option value="">Select Manager</option>
                            <?php foreach($managers as $manager): ?>
                            <option value="<?php echo $manager['id']; ?>">
                                <?php echo htmlspecialchars($manager['full_name']); ?>
                            </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <button type="submit" name="add_department" class="btn btn-primary w-100">Add Department</button>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-buildings me-2"></i>Departments List</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead class="table-dark">
                            <tr>
                                <th>ID</th>
                                <th>Department Name</th>
                                <th>Manager</th>
                                <th>Created Date</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($departments as $dept): ?>
                            <tr>
                                <td>D<?php echo str_pad($dept['id'], 3, '0', STR_PAD_LEFT); ?></td>
                                <td><?php echo htmlspecialchars($dept['department_name']); ?></td>
                                <td>
                                    <?php if($dept['manager_name']): ?>
                                        <span class="badge bg-info"><?php echo htmlspecialchars($dept['manager_name']); ?></span>
                                    <?php else: ?>
                                        <span class="text-muted">Not assigned</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo date('Y-m-d', strtotime($dept['created_at'])); ?></td>
                                <td>
                                    <button class="btn btn-sm btn-outline-warning">
                                        <i class="bi bi-pencil"></i>
                                    </button>
                                    <button class="btn btn-sm btn-outline-danger">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>