<?php
session_start();
require_once '../config/database.php';


if (!isset($_SESSION['user_id'])) {
    die("Unauthorized access");
}

$leave_id = $_GET['id'] ?? 0;
$is_admin = isset($_GET['admin']) && $_GET['admin'] == '1';

try {
    // Get leave details with employee information
    $query = "SELECT l.*, e.full_name, e.department, e.contact_number, 
                     u.email as employee_email, u2.username as approved_by_name
              FROM leaves l 
              JOIN employees e ON l.employee_id = e.id 
              LEFT JOIN users u ON e.user_id = u.id 
              LEFT JOIN users u2 ON l.approved_by = u2.id 
              WHERE l.id = ?";
    
    $stmt = $pdo->prepare($query);
    $stmt->execute([$leave_id]);
    $leave = $stmt->fetch();
    
    if (!$leave) {
        die("<div class='alert alert-danger'>Leave application not found!</div>");
    }
    
    
    
    // Get leave balance at time of application
    $stmt = $pdo->prepare("SELECT * FROM leave_balance WHERE employee_id = ?");
    $stmt->execute([$leave['employee_id']]);
    $balance = $stmt->fetch();
    
    // Calculate available balance
    $available = 0;
    switch ($leave['leave_type']) {
        case 'Casual Leave':
            $available = ($balance['casual_leaves'] ?? 14) - ($balance['used_casual'] ?? 0);
            break;
        case 'Sick Leave':
            $available = ($balance['sick_leaves'] ?? 7) - ($balance['used_sick'] ?? 0);
            break;
        case 'Annual Leave':
            $available = ($balance['annual_leaves'] ?? 21) - ($balance['used_annual'] ?? 0);
            break;
    }
    
    ?>
    <div class="row">
        <div class="col-md-6">
            <h6>Employee Information</h6>
            <table class="table table-sm">
                <tr>
                    <th style="width: 40%;">Name:</th>
                    <td><?php echo htmlspecialchars($leave['full_name']); ?></td>
                </tr>
                <tr>
                    <th>Department:</th>
                    <td><?php echo htmlspecialchars($leave['department']); ?></td>
                </tr>
                <tr>
                    <th>Contact:</th>
                    <td><?php echo htmlspecialchars($leave['contact_number'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <th>Email:</th>
                    <td><?php echo htmlspecialchars($leave['employee_email'] ?? 'N/A'); ?></td>
                </tr>
            </table>
        </div>
        
        <div class="col-md-6">
            <h6>Leave Information</h6>
            <table class="table table-sm">
                <tr>
                    <th style="width: 40%;">Leave Type:</th>
                    <td>
                        <span class="badge bg-<?php 
                            echo $leave['leave_type'] == 'Casual Leave' ? 'primary' : 
                                 ($leave['leave_type'] == 'Sick Leave' ? 'info' : 
                                 ($leave['leave_type'] == 'Annual Leave' ? 'success' : 'warning'));
                        ?>">
                            <?php echo htmlspecialchars($leave['leave_type']); ?>
                        </span>
                    </td>
                </tr>
                <tr>
                    <th>Period:</th>
                    <td>
                        <?php echo date('M d, Y', strtotime($leave['start_date'])) . ' to ' . 
                              date('M d, Y', strtotime($leave['end_date'])); ?>
                    </td>
                </tr>
                <tr>
                    <th>Total Days:</th>
                    <td><?php echo $leave['total_days']; ?> working days</td>
                </tr>
                <tr>
                    <th>Applied On:</th>
                    <td><?php echo date('M d, Y H:i', strtotime($leave['applied_date'])); ?></td>
                </tr>
                <tr>
                    <th>Status:</th>
                    <td>
                        <span class="badge bg-<?php 
                            echo $leave['status'] == 'approved' ? 'success' : 
                                 ($leave['status'] == 'rejected' ? 'danger' : 
                                 ($leave['status'] == 'cancelled' ? 'secondary' : 'warning'));
                        ?>">
                            <?php echo ucfirst($leave['status']); ?>
                        </span>
                    </td>
                </tr>
                <?php if ($leave['approved_by_name']): ?>
                <tr>
                    <th>Processed By:</th>
                    <td><?php echo htmlspecialchars($leave['approved_by_name']); ?></td>
                </tr>
                <tr>
                    <th>Processed On:</th>
                    <td><?php echo date('M d, Y H:i', strtotime($leave['approved_date'])); ?></td>
                </tr>
                <?php endif; ?>
            </table>
        </div>
        
        <div class="col-12 mt-3">
            <h6>Reason for Leave</h6>
            <div class="card">
                <div class="card-body">
                    <p class="mb-0"><?php echo nl2br(htmlspecialchars($leave['reason'])); ?></p>
                </div>
            </div>
        </div>
        
        <?php if ($is_admin && $leave['status'] == 'pending'): ?>
        <div class="col-12 mt-4">
            <div class="alert alert-info">
                <h6><i class="bi bi-info-circle"></i> Leave Balance Information</h6>
                <p class="mb-2">
                    Available <?php echo $leave['leave_type']; ?> balance: <strong><?php echo $available; ?> days</strong><br>
                    Requested leave: <strong><?php echo $leave['total_days']; ?> days</strong>
                </p>
                <?php if ($available >= $leave['total_days']): ?>
                <p class="text-success mb-0">
                    <i class="bi bi-check-circle"></i> Sufficient balance available
                </p>
                <?php else: ?>
                <p class="text-danger mb-0">
                    <i class="bi bi-exclamation-triangle"></i> 
                    Insufficient balance (Short by <?php echo $leave['total_days'] - $available; ?> days)
                </p>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
    <?php
    
} catch (Exception $e) {
    echo "<div class='alert alert-danger'>Error: " . htmlspecialchars($e->getMessage()) . "</div>";
}
?>